function [ S1 ] = Assemble_Time( orig_delta,r,d,A)
%Assemble the time matrix of Galerkin in S^r_d over interval.
%   Integrate the mass matrix associated to the time part of the Galerkin
%   approximation.  That is given A(x)u_t - [B(x)u(x)]' = 0, compute
%   \int^b_a{N_i*A(x)*N_j}dx for i,j ranging over the S^r_d normalized
%   B-spline basis.  A(x) is the function handle expressing the time
%   coefficient. orig_delta is the UNextended knot sequence.   

%Number of elements
nelm = size(orig_delta,2)-1;

%Extended parition for computing product basis splines
[extdelta,n] = extpar(orig_delta,r,d);

%Extract the weights to be used
[w,rq,sq] = quadset(6);

%Assemble Mass Matrix
S1 = zeros(n,n);
In = eye(n);                                      %To express basis splines
for i=1:n
    for j=1:n
        for k=1:nelm %For this pair of basis products cycle over all intervals
            %Extract weight sample points
            bk = orig_delta(1,k+1);
            ak = orig_delta(1,k);
            sample = ak*rq+bk*sq;
            
            %Evaluate Coefficient and Basis Splines at samples
            vali = sval2(d,extdelta,n,In(i,:),sample); 
            valj = sval2(d,extdelta,n,In(j,:),sample);
            vala = arrayfun(A,sample);
            
            S1(i,j) = S1(i,j) + (bk-ak)/2*sum(w.*vali.*valj.*vala); %Schumaker (1.62)
        end
    end
end

end

